#ifndef __CWaveCycle__
#define __CWaveCycle__

//	===========================================================================

#include "CControl.hpp"
using Exponent::GUI::Controls::CControl;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CWaveCycle CWaveCycle.hpp
			 * @brief Cyclic wave display
			 * 
			 * Displays a cycle wave display
			 *
			 * @date 08/10/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CWaveCycle.hpp,v 1.5 2007/02/08 21:07:54 paul Exp $
			 */
			class CWaveCycle : public CControl
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

				/**
				 * Construction
				 * @param root The root control
				 * @param uniqueId The id of the control
				 * @param area The size of the control
				 */
				CWaveCycle(IControlRoot *root, const long uniqueId, const CRect &area);

				/**
				 * Destruction
				 */
				virtual ~CWaveCycle();

//	===========================================================================

				/**
				 * Draw the control
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

				/**
				 * Set the next value
				 * @param value The value to add to the value cycle
				 */
				void setNextValue(const double value);

//	===========================================================================


			protected:

//	===========================================================================

				CPolygon m_wave;			/**< The waveform */
				long m_position;			/**< The position in the waveform */
			};
		}
	}
}
#endif	// End of CWaveCycle.hpp